---
layout:     post
title:      「体能训练理论」之动力链
subtitle:   「健身先健脑」科学的运动需要科学的运动理论
date:       2017-07-10
author:     BY
header-img: img/post-bg-mma-0.png
catalog: true
tags:
    - 健身
    - 生活
---


## 引言

与其说体能训练是一种行为，不如说体能训练是一种程序。只要符合逻辑，就可以自由组合。
 那么体能训练的逻辑是什么？我们将之总结为：[**动力链**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E5%8A%A8%E5%8A%9B%E9%93%BE/)、[**功能性**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E5%8A%9F%E8%83%BD%E6%80%A7/)、[**金字塔**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E9%87%91%E5%AD%97%E5%A1%94/)。
 
##  动力链

如果说 **五大运动素质**（力量、速度、耐力、灵敏、柔韧）代表了体能的宏观表现，那么动力链理论则阐释了人体解剖结构在运动中的客观规律，这二者同为人体的本质属性。

动力链这一理论早在1875年就被提出过，当时的定义还很简单，就是指几个相邻的关节所组成的复杂动作单元。后来在不断地实践与研究中，动力链理论也不断的升级，越来越清晰，越来越客观，也越来越复杂，并且逐渐成为了体能训练师们必备的思考工具之一。

来看看动力链的英文解释:

>The concept of the kinetic chain originated in 1875, when a mechanical engineer named Franz Reuleaux proposed that if a series of overlapping segments were connected via pin joints, these interlocking joints would create a system that would allow the movement of one joint to affect the movement of another joint within the kinetic link. Dr. Arthur Steindler adapted this theory in 1955, and included an analysis of human movement. Steindler suggested that the extremities be viewed as a series of rigid, overlapping segments and defined the kinetic chain as a "combination of several successively arranged joints constituting a complex motor unit." The movements that occur within these segments present as two primary types—open and closed.

这种模糊形容根本无法让人们理解它真正的内核，虽然它看起来就像是一堆联动的齿轮和杠杆。实际上它也真的很像一堆齿轮和杠杆，有的负责驱动，有的负责传力，有的负责稳定。

为了方便大家理解，下面我要将这个理论拆解开来跟大家分享。

首先，我们需要从以上的定义中提炼出来一些关键词，比如说 “运动”、“几个”、“相邻”等等。那么这几个词分别代表了什么？

1. 我们讨论问题的角度是**运动**的；
2. 我们需要考虑的**人体解剖结构**问题；
3. 我们需要考虑相邻关节的**协作关系**；
4. 我们需要分析每一个关节的**使用特点**。

所以，它似乎并不能被完美的定义，而是只可意会不可言传。
 那么关于动力链，我们需要掌握两个最基本的知识：**动力链模型**、**开链与闭链**。
 
### 动力链模型

在动力链理论中，我们考虑运动的最小单位是**关节**，诸多关节运动的协作产生了整体上的复杂动作。所以每一个关节的功能就决定了整体动作的表现，任何一个关节功能受限都会导致整体动作的失衡。 

而我们所指的关节功能，可以从生物力学角度简单的概括为：

- **灵活**(**M**,Mobility)
- **稳定**(**S**,Stability)

但看起来简单的两个词，其实意义非常。

#### 什么是灵活？

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg2avap5sj30ao08rdg4.jpg)

很多人的第一反应就是能自由的运动呗~然后部分专业人士可能会想到活动度。但是你的关节如果仅仅具备很好的活动度就能够胜任运动中的需求么？显然是不能的。所以灵活的意义远不止关节活动度，关节活动度仅仅是灵活的基础，而更重要的还有产力的能力。没错，这里的灵活既包括关节主被动活动范围，也包括产力的能力，比如产力的大小，产力的快慢等等。
 举个例子：小明的髋关节活动范围非常好，能竖叉能横叉，但是臀大肌并没有很好的力量，所以不能够支撑你的跑步与跳跃，所以此时的髋关节灵活性仍然是不足的，只不过这里强调的是力量的缺失。
 
#### 什么是稳定？

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg2b1gendj30fa08t74f.jpg)

稳定就是稳定呗~就是待着不动呗~就是牢固呗~灵活还能说出个关节活动度，而稳定的定义真的让很多人摸不到头脑，因为似乎“稳定”一词已经很好地形容了关节的功能表现。但是实际上我们仍然可以对其进行深究，并且这样做是有意义的，因为表现的不同直接影响训练的手段。

如果我们把“稳定”定义为是一种提供安全性的保护，那么我们就可以假想出两个现象：

1. 一个非常贵重的瓷器抱在手中，我不能把它摔碎，所以我抱着不动~
2. 同样是这个非常贵重的瓷器抱在手中，我不能把它摔碎，但是我可以慢慢的把它放在地上。
同样是保护瓷器不被摔碎，但是却有两个表现，一个是hold住，另外一个是慢慢的放在地上，一个不动，一个动。所以我们人体关节的稳定也是如此，既包括保持身体姿态，关节位置的相对固定，也包括有控制的缓冲外力，退让做功。

![](https://ws1.sinaimg.cn/large/006tKfTcgy1fhg2b6eo7uj30m80h477k.jpg)

举个例子：我们的核心区域在运动中应该尽可能的保持姿态的稳定，所以是抱着瓷器不动；我们的膝关节在走路与跑步中从伸到屈，缓冲脚落地产生的冲击力，所以是抱着瓷器往下放。 

在了解了 SM (稳定和灵活)的意义之后，更重要的是明白：这两种并不会孤立的存在，而是相辅相成同时存在的，只不过在人体整体动力链中体现的侧重点不一样，在肢体的协同运动中扮演的角色不一样。比如对于核心区域来说，灵活恰是其稳定的基础，因为不同体位下脊柱的排列形式直接影响稳定的表现。

当 SM 代表了关节功能之后，在人体的整体运动结构中，不同的关节所凸显出来的功能是不同的，并且它们遵循一定的逻辑分布。

![](https://ws3.sinaimg.cn/large/006tKfTcgy1fhg2bewsh2j30hs0b0t8y.jpg)

从下往上说：

1. 足弓——稳定

	第一个缓冲冲击力的关节，并且没有多大的关节活动度。
	
2. 足踝——灵活
	
	“足” “踝”形成了一个稳定与灵活兼备的整体，但是在运动中它是下肢蹬伸最后一个主动发力的关节，并且无时无刻不在调整着身体与地面之间的位置关系，所以在这里我们更强调它的灵活性。
	
3. 膝关节——稳定

	强大的承重关节，且仅存在屈伸的动作（屈膝位的内外旋的意义是提供可控的缓冲空间，并非叫你主动旋转），更重要的是，无论走路、跑步、跳跃，膝关节都是非常重要的离心缓冲关节。
4. 髋关节——灵活
	
	强大的发力关节，而且活动范围也非常广泛，它引领着下肢的动作产生。但是由于位置与功能的特殊，所以其稳定性也相当重要，直接可以影响核心的稳定结构，特别是在闭链状态下。

5. 腰椎——稳定

	相对的绝对稳定体。所谓绝对，是因为腰椎所处的位置恰好为核心地带，这里的功能是维持姿态以及为上下肢的运动提供稳定基础，所以要“抱着缸不动”。而所谓相对，是因为不同的体位下腰椎的姿态是需要随之调整的，并不能以不变应万变。

6. 胸椎——灵活

	胸椎的灵活性其实并不好，但是相比于腰椎来说就好太多了，特别是在旋转动作上。在旋转鞭打的动作模式中，胸椎是继下肢产力之后的第一个角速度放大的关节，其灵活程度直接影响了上肢的鞭打效果。当然，在更多的时候胸椎要参与承重，但即便承重，也是以其良好的灵活性为基础的，比如说手臂上举过头负重的动作。

7. 颈椎——稳定
	
	虽然很灵活，但却需要很稳定！因为头部的位置变化会直接改变身体肌张力的大小分布，这个不仅可以让我们身体姿态发生变化，还会破坏掉本体感觉的准确性。当然，这也是猫在空中可以转体的原因，以及为什么我们打拳的时候不能回头。

8. 肩胛胸关节——稳定
	
	这是一个很奇葩的关节，从动力链结构上看，它是稳定关节，但稳定的并不是它自己，而是肩关节。在实际运动中，肩胛胸关节和肩关节是联动运动的，而且前者为后者提供稳定性，是后者得以安全展现灵活的基础。但是这个“稳定”恰恰是通过肩胛胸关节本身的灵活性来展现的，比如手臂上举时的上回旋。

9. 肩关节——灵活
 
	没的说，人体最灵活的关节，也是人体最不稳定的关节，其球窝关节的解剖结构已经说明了一切。

10. 肘关节——稳定

	结构上跟膝关节相对，但是实际上要比膝关节灵活的多。所以如果进化论成立的话，人类从四脚着地变成双脚着地的过程，使我们的下肢关节趋向于稳定，上肢关节趋向于灵活。而这正与 “开链”或者“闭链”的需求相适应。
	
### 开链&闭链

我们的关节同时存在S与M，而在整体的运动中有不同的体现，甚至于同样是S或者M的上下肢关节却存在了显著的差别。那么在此我们需要引出一个新的概念：**开链** & **闭链**。

#### 开链

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg2bltahoj30dg09h74k.jpg)

开链，简单地说就是我们身体产生力量，改变了外界物体的运动状态。比如说哑铃二头弯举，投掷，摘苹果等动作都是开链动作。我们可以认为我们的身体在对抗趋于无穷小的阻力，那么我们就可以随意改变物体的运动状态，随便摆弄它，所以此时我们的肢体的灵活性就可以充分的发挥。比如我们的上肢就是以开链运动为主的，所以它整体表现出更好的灵活性。

#### 闭链

![](https://ws3.sinaimg.cn/large/006tKfTcgy1fhg2bq4z76j30fk0dp0tf.jpg)

闭链，简单的说就是我们的身体产生力量，却没能推动外界的物体，反而改变了我们自身的运动状态。比如说跑步与深蹲，我们扒地，我们蹬地，并没有让地板产生位移，我们自己却向前或者向上运动了。所以我们可以认为闭链运动时，我们的身体在对抗趋于无穷大的阻力，我们根本不可能改变它，所以只能运动我们自己。而在面对这样无穷大的阻力的时候，我们需要将我们的关节摆在力学结构最优的位置上才能发挥我们自身的最大经济性和效率，而且在这个状态下，各个关节的位置直接影响了身体的整体姿态和状态，所以灵活性被抑制。我们的下肢，最擅长、做的最多的就是闭链运动，所以它更加的趋于稳定。

开链和闭链直接影响我们的训练适应，因为它们所表现的力学结构是不同的。


## 总结

了解动力链并不是让我们**装逼**的，而是让我们更加了解人体的客观规律来指导训练的。

它是一个非常好的思考工具。比如我们在训练下肢力量的时候，我们就需要考虑髋关节灵活性对于下肢力量表现的影响，于是乎我们可能更加重点强化髋的产力能力。但是当考虑到屈髋动作时，也许实际中更多的是开链的屈髋，所以我们就能以此为依据来选择髂腰肌和股直肌的训练动作。

除此之外，每个关节本身的功能完整性是非常重要的，如果一个关节有功能缺陷，那么在整体运动中它就不能够尽到它的职责，所以一定会有另外一个或者几个关节来代偿它的功能，那么就相当于一个3人的团队，一个请假了，另外两个就得加班。如果一次两次没关系，它要是请了一年的产假，那么另外俩人可能会由于长期超负荷工作而积劳成疾。当然，对于公司来说我可以再雇人，但是我们的人体可没有能再多长一个关节之说。

所以其实很多跑步膝的问题恰是由于髋和踝的功能缺陷而导致的。

![](https://ws3.sinaimg.cn/large/006tKfTcgy1fhg2buv4nwj30ia0a2dfx.jpg)

**最后我要再次强调**：任何一个关节，稳定与灵活同时存在，只不过体现的程度和侧重不同。在动力链中，灵活的关节不代表没有稳定，更不代表稳定不重要；稳定的关节也需要灵活，而且灵活可能是稳定的基础。

了解了动力链，你会更懂运动中的人体，也许你有了思考问题的方向，但仍然缺少方法，所以你还需要具备[「功能性」](http://qiubaiying.github.io/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E5%8A%9F%E8%83%BD%E6%80%A7/)的思维方式。

>转自 [《体能训练之动力链》](https://zhuanlan.zhihu.com/p/20774747)